@php
    $plan = \App\Models\Utility::getChatGPTSettings();
@endphp
{{ Form::open(['url' => 'transfer','class'=>'needs-validation','novalidate']) }}
<div class="modal-body">
    <div class="row">
        @if ($plan->enable_chatgpt == 'on')
            <div>
                <a href="#" data-size="md" data-ajax-popup-over="true"
                    data-url="{{ route('generate', ['transfer']) }}" data-bs-toggle="tooltip" data-bs-placement="top"
                    title="{{ __('Generate') }}" data-title="{{ __('Generate content with AI') }}"
                    class="btn btn-primary btn-sm float-end">
                    <i class="fas fa-robot"></i>
                    {{ __('Generate with AI') }}
                </a>
            </div>
        @endif
        <div class="form-group  col-md-6">
            {{ Form::label('from_account', __('From Account'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::select('from_account', $bankAccount, null, ['class' => 'form-control', 'required' => 'required']) }}
            <div class="text-xs mt-1">
                {{ __('Create from account here.') }} <a href="{{ route('bank-account.index') }}"><b>{{ __('Create from account') }}</b></a>
            </div>
        </div>
        <div class="form-group  col-md-6">
            {{ Form::label('to_account', __('To Account'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::select('to_account', $bankAccount, null, ['class' => 'form-control', 'required' => 'required']) }}
            <div class="text-xs mt-1">
                {{ __('Create to account here.') }} <a href="{{ route('bank-account.index') }}"><b>{{ __('Create to account') }}</b></a>
            </div>
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('amount', __('Amount'), ['class' => 'form-label']) }}<x-required></x-required>
            <div class="form-icon-user">
                {{ Form::number('amount', '', ['class' => 'form-control', 'required' => 'required', 'step' => '0.01', 'placeholder'=>__('Enter Amount')]) }}
            </div>
        </div>
        <div class="form-group  col-md-6">
            {{ Form::label('date', __('Date'), ['class' => 'form-label']) }}<x-required></x-required>
            <div class="form-icon-user">
                {{ Form::date('date', date('Y-m-d'), ['class' => 'form-control', 'required' => 'required']) }}
            </div>
        </div>
        <div class="form-group  col-md-6">
            {{ Form::label('reference', __('Reference'), ['class' => 'form-label']) }}
            <div class="form-icon-user">
                {{ Form::text('reference', '', ['class' => 'form-control', 'placeholder'=>__('Enter Reference')]) }}
            </div>
        </div>
        <div class="form-group  col-md-12">
            {{ Form::label('description', __('Description'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::textarea('description', '', ['class' => 'form-control', 'rows' => 3, 'required' => 'required', 'placeholder'=>__('Enter Description')]) }}
        </div>
    </div>
</div>
<div class="modal-footer">
    <input type="button" value="{{ __('Cancel') }}" class="btn  btn-light" data-bs-dismiss="modal">
    <input type="submit" value="{{ __('Create') }}" class="btn  btn-primary">
</div>
{{ Form::close() }}
